const express = require('express');
const mysql = require('mysql');
const cors = require('cors');
const dotenv = require('dotenv');
const bodyParser = require('body-parser');
const axios = require('axios');

dotenv.config();
const app = express();
app.use(cors());
app.use(express.json());
app.use(bodyParser.json());

const db = mysql.createConnection({
    host: process.env.DB_HOST,
    user: process.env.DB_USER,
    password: process.env.DB_PASS,
    database: process.env.DB_NAME
});

db.connect(err => {
    if (err) throw err;
    console.log("Connected to MySQL Database");
});

app.post('/verify', async (req, res) => {
    const { userId, documentNumber, documentType } = req.body;
    try {
        const response = await axios.post('https://api.confirmident.com.ng/verify', {
            document_number: documentNumber,
            document_type: documentType
        }, {
            headers: { 'Authorization': `Bearer ${process.env.CONFIRMIDENT_API_KEY}` }
        });

        const verificationStatus = response.data.status;
        const sql = "UPDATE users SET verification_status = ? WHERE id = ?";
        db.query(sql, [verificationStatus, userId], (err, result) => {
            if (err) return res.status(500).json({ error: err.message });
            res.json({ message: "Verification updated", status: verificationStatus });
        });
    } catch (error) {
        res.status(500).json({ error: "Verification failed" });
    }
});

const PORT = process.env.PORT || 5000;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
