import React, { useState } from 'react';
import axios from 'axios';

function App() {
  const [documentNumber, setDocumentNumber] = useState('');
  const [documentType, setDocumentType] = useState('');
  const [status, setStatus] = useState(null);

  const handleVerify = async () => {
    try {
      const response = await axios.post('http://localhost:5000/verify', {
        userId: 1,  // Replace with actual user ID
        documentNumber,
        documentType
      });
      setStatus(response.data.status);
    } catch (error) {
      setStatus("Verification failed");
    }
  };

  return (
    <div>
      <h1>Mkolo Verify</h1>
      <input 
        type="text" 
        placeholder="Document Number" 
        value={documentNumber} 
        onChange={(e) => setDocumentNumber(e.target.value)} 
      />
      <input 
        type="text" 
        placeholder="Document Type" 
        value={documentType} 
        onChange={(e) => setDocumentType(e.target.value)} 
      />
      <button onClick={handleVerify}>Verify</button>
      {status && <p>Verification Status: {status}</p>}
    </div>
  );
}

export default App;
